/*
 * Decompiled with CFR 0.152.
 */
package io.github.ennuil.libzoomer.mixin;

import io.github.ennuil.libzoomer.api.ZoomInstance;
import io.github.ennuil.libzoomer.api.ZoomOverlay;
import io.github.ennuil.libzoomer.api.ZoomRegistry;
import net.minecraft.class_329;
import net.minecraft.class_4587;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_329.class})
public class InGameHudMixin {
    @Unique
    private boolean shouldCancelOverlay = false;

    @Inject(at={@At(value="INVOKE", target="net/minecraft/client/MinecraftClient.getLastFrameDuration()F")}, method={"render(Lnet/minecraft/client/util/math/MatrixStack;F)V"})
    public void injectZoomOverlay(class_4587 matrices, float tickDelta, CallbackInfo ci) {
        this.shouldCancelOverlay = false;
        for (ZoomInstance instance : ZoomRegistry.getZoomInstances()) {
            ZoomOverlay overlay = instance.getZoomOverlay();
            if (overlay == null) continue;
            overlay.tickBeforeRender();
            if (!overlay.getActive()) continue;
            if (!overlay.cancelOverlayRendering()) {
                // empty if block
            }
            this.shouldCancelOverlay = true;
            overlay.renderOverlay();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"renderSpyglassOverlay", "renderOverlay"}, cancellable=true)
    public void cancelOverlay(float scale, CallbackInfo ci) {
        if (this.shouldCancelOverlay) {
            ci.cancel();
        }
    }

    @Inject(at={@At(value="INVOKE", target="net/minecraft/client/network/ClientPlayerEntity.getFrozenTicks()I")}, method={"render(Lnet/minecraft/client/util/math/MatrixStack;F)V"})
    public void disableOverlayCancelling(class_4587 matrices, float tickDelta, CallbackInfo ci) {
        if (this.shouldCancelOverlay) {
            this.shouldCancelOverlay = false;
        }
    }
}

